******************************
* SET OPTIONS; SET LOCATIONS *
******************************
clear all
set trace off
set more off
global external_dir "D:\Dropbox\Michigan\RDC Project\AEJ Data Set\"			/*CHANGE THIS TO THE DIRECTORY THAT HAS THE FILES*/
global internal_dir "\projects\"											/*This is an internal RDC directory*/

capture log close


**********************************************
* Merge stock by citizenship data into panel *
**********************************************
use "$internal_dir/data/panel.dta", clear

*Merge in 1980 stocks by citizenship status
merge m:1 country using "$internal_dir/data/Census 1980/census1980est_stock_cit.dta"
drop _merge
merge m:1 country using "$internal_dir/data/Census 1980/census1980est_stock_noncit.dta"
drop _merge

*Deal with 0's
replace citizen_stock1980 = 0 if stock1980!=. & citizen_stock1980==.
replace noncitizen_stock1980 = 0 if stock1980!=. & noncitizen_stock1980==.

tempfile dataset
save `dataset', replace

*Keep necessary variables and years
keep country year inflows stock1980 citizen_stock1980 noncitizen_stock1980 population1980 HI
drop if inflows==.
drop if stock1980==.
keep if year>=1980 & year<=2004

*Generate key variables
gen p_stock1980 = stock1980/population1980
gen p_stock_cit1980 = citizen_stock1980/population1980
gen p_stock_noncit1980 = noncitizen_stock1980/population1980
gen p_inflows = inflows/population1980


***********
* Table 5 *
***********
xtset country year
xtreg p_inflows i.year c.year#i.country HI c.HI#c.p_stock1980, fe cl(country)
	outreg2 using "$internal_dir/output/table5", replace word keep(HI c.HI#c.p_stock1980) dec(4) nocons
xtreg p_inflows i.year c.year#i.country HI c.HI#c.p_stock_cit1980 c.HI#c.p_stock_noncit1980, fe cl(country)
	test c.HI#c.p_stock_cit1980 = c.HI#c.p_stock_noncit1980
	local p = r(p)
	outreg2 using "$internal_dir/output/table5", append word ///
		keep(HI c.HI#c.p_stock_cit1980 c.HI#c.p_stock_noncit1980) ///
		adds(Equal effect p,`p') af(g) dec(4) nocons
			
